package gov.va.vinci.dart.json.builder;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.json.PersonDetailsView;
import gov.va.vinci.dart.json.atom.AtomLinkFactory;
import gov.va.vinci.dart.json.atom.LinkListView;
import gov.va.vinci.dart.json.atom.LinkView;
import gov.va.vinci.dart.json.atom.Relation;

@Component
public class PersonDetailsViewBuilder {
	@Autowired 
	private AtomLinkFactory linkFactory;

	@Autowired
	private GroupListViewBuilder groupListViewBuilder;

	@Autowired
	private RoleListViewBuilder roleListViewBuilder;
	
	@Autowired
	private RoleAndGroupListViewBuilder roleAndGroupListViewBuilder;


	public PersonDetailsView build(final Person person, final boolean bIncludeLinks) {
		PersonDetailsView result = new PersonDetailsView();
		
		result.setId(person.getId());
		result.setName(person.getName());
		result.setDescription(person.getDescription());
		result.setFullName(person.getFullName());
		result.setLocationId(person.getLocation().getId());
		result.setLocationName(person.getLocation().getName());
		
		result.setGroups(groupListViewBuilder.build(person.getGroups(), bIncludeLinks));
		result.setRoles(roleListViewBuilder.build(person.getRoles()));
		
		result.setRoleAndGroupList(roleAndGroupListViewBuilder.build(person.getRoles(), person.getGroups()));
		
		
		if( bIncludeLinks == true ) {
			LinkListView linkListView = new LinkListView();
			result.setLinks(linkListView);
	
			LinkView link = linkFactory.buildLink("/persons/" + person.getId(), Relation.SELF);
			linkListView.getLink().add(link);
			link = linkFactory.buildLink("/persons/" + person.getId() + "/tasks", Relation.RELATED);
			linkListView.getLink().add(link);
			link = linkFactory.buildLink("/persons/" + person.getId() + "/roles", Relation.RELATED);
			linkListView.getLink().add(link);
			link = linkFactory.buildLink("/persons/" + person.getId() + "/groups", Relation.RELATED);
			linkListView.getLink().add(link);
		}

		return result;
	}
}
